/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.domain;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.PartitionedMessage;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import com.ibm.hwmca.p.pa.domain.SurveillanceAnalysisDomain;
import com.ibm.hwmca.p.pa.event.GlobalSurveillanceDataEvent;
import com.ibm.hwmca.p.pa.event.GlobalSurveillanceDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.AnalysisDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GlobalSurveillanceAnalysisDomain
extends SurveillanceAnalysisDomain {
    private static final String TRACE_MASKT = "PPAGSADT";
    private static final String TRACE_MASKF = "PPAGSADF";
    private static final String TRACE_MASKD = "PPAGSADD";
    public static final DomainIdentifier GSAD_DOMAINID = new DomainIdentifier("GSAD");
    public static final String MSG_PART_DP_DIAG = "DP_DIAG";

    public GlobalSurveillanceAnalysisDomain() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public GlobalSurveillanceAnalysisDomain(DomainIdentifier did) {
        super(did);
    }

    protected Set instantiateDomains() {
        Trace.trace(TRACE_MASKD, "--> instantiateDomains");
        this.realInstanceSet = new HashSet();
        try {
            Trace.trace(TRACE_MASKD, "building domain instance [" + GSAD_DOMAINID.getDID() + "]");
            GlobalSurveillanceAnalysisDomain gsad = (GlobalSurveillanceAnalysisDomain)this.getClass().newInstance();
            gsad.setDomainId(GSAD_DOMAINID);
            this.realInstanceSet.add(gsad);
        }
        catch (Exception e) {
            // empty catch block
        }
        super.instantiateDomains();
        Trace.trace(TRACE_MASKD, "<-- instantiateDomains");
        return this.realInstanceSet;
    }

    protected void remoteConsoleAdd(RemoteConsoleSystem rcs) {
        if (this.getParticipants().contains(rcs)) {
            return;
        }
        super.remoteConsoleAdd(rcs);
        HashSet<RemoteConsoleSystem> targetSystems = new HashSet<RemoteConsoleSystem>();
        targetSystems.add(rcs);
        this.beginProblemDataSynchronization(targetSystems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PASystem getPrimary() {
        PASystem primarySys = DistributedAnalysisDomain.localConsole;
        Set set = this.getActiveConsoles();
        synchronized (set) {
            Iterator peerIter = this.getActiveConsoles().iterator();
            PASystem peerSys = null;
            while (peerIter.hasNext()) {
                peerSys = (PASystem)peerIter.next();
                if (primarySys.getMTMS().compareTo(peerSys.getMTMS()) >= 0) continue;
                primarySys = peerSys;
            }
        }
        return primarySys;
    }

    protected void handleMessage(PartitionedMessage msg, RemoteEntity sender2) {
        String partId = (String)((Object)msg.getPartition());
        if (partId.equals(MSG_PART_DP_DIAG)) {
            Trace.trace(TRACE_MASKF, this.getDomainTrace(""));
            Trace.trace(TRACE_MASKF, "received remote problem for diagnosis");
            this.handleSurveillanceProblem(msg);
        } else {
            super.handleMessage(msg, sender2);
        }
    }

    private void handleSurveillanceProblem(Message msg) {
        if (!this.isPrimary()) {
            // empty if block
        }
        CommonProblem prob = null;
        try {
            String xmlProb = (String)((Object)msg.getPayload());
            String probTag = xmlProb.substring(1, xmlProb.indexOf(" "));
            prob = (CommonProblem)XMLHelper.rebuildObject(xmlProb, probTag);
            prob.localize();
            prob.setProblemNumber(Integer.MIN_VALUE);
            Trace.trace(TRACE_MASKF, "sequence number:" + prob.getSequenceNumber());
            Trace.trace(TRACE_MASKF, "reporting RemoteMachineSystem:" + prob.getReportingRemoteMachineSystem());
            Trace.trace(TRACE_MASKF, "primary analyzing ConsoleSystem:" + prob.getPrimaryAnalyzingConsoleSystem());
            Trace.trace(TRACE_MASKF, "failing system:" + prob.getFailingSystem());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "could not rebuild problem");
            Trace.trace(TRACE_MASKT, e);
        }
        Trace.trace(TRACE_MASKD, "Post the event that we will create from the problem received");
        GlobalSurveillanceDataEvent gsde = new GlobalSurveillanceDataEvent(this);
        gsde.setSystem(prob.getPrimaryAnalyzingConsoleSystem());
        gsde.setData(prob);
        this.evtMgr.handleEvent(gsde);
    }

    protected boolean synchronizeProblemDataDuringInitialization() {
        return true;
    }

    public AnalysisDomainAnalysisEvent getSystemAnalysisEvent(Object source) {
        return new GlobalSurveillanceDomainAnalysisEvent(source);
    }

    public static GlobalSurveillanceDataEvent createGSADE(CommonProblem cp) {
        Trace.trace(TRACE_MASKD, "building GSADE");
        GlobalSurveillanceDataEvent gsde = new GlobalSurveillanceDataEvent(new String("GSAD creation"));
        gsde.setPrimaryAnalyzingConsoleSystem(cp.getPrimaryAnalyzingConsoleSystem());
        gsde.setReportingSystem(cp.getReportingRemoteMachineSystem());
        gsde.setFailingSystem(cp.getFailingSystem());
        gsde.setRefcode(cp.getRefcode());
        gsde.getFruList().addAll(cp.getParts());
        gsde.setSystem(cp.getPrimaryDataEvent().getSystem());
        return gsde;
    }
}

